<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet 
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:msxsl="urn:schemas-microsoft-com:xslt"
	xmlns:vb="http://www.mediachase.ru/vb"
	xmlns:js="http://www.mediachase.ru/js"
	xmlns:dt="urn:schemas-microsoft-com:datatypes"
	version="1.0">
	<msxsl:script language="C#" implements-prefix="vb">
	string GetCDate(XPathNodeIterator who)
	{
		string s=who.Current.Value;
		if(s.Length &gt; 9)
			s = s.Substring(0,10);
		return s;
	}
	</msxsl:script>
	<xsl:template match="/">
			<xsl:for-each select="//Report/Groups/Group">
				<xsl:if test="count(./Groups/Group/Item)>0">
					<DIV class="page_title">
						'<xsl:value-of select="./@Name" />' - Group by <xsl:value-of select="./Groups/@Name" />
					</DIV>
					<table><tr><td height="15px"></td></tr></table>
					<xsl:for-each select="./Groups/Group">
						<xsl:if test="count(./Item)>0">
							<table><tr><td height="7px"></td></tr></table>
							<DIV class="ResourceSubhead"><B><xsl:value-of select="./@Name" /></B></DIV>
							<table><tr><td height="1px"></td></tr></table>
							<table class="SectionTable" 
									style="BORDER-RIGHT: #c4c4b4 1px; BORDER-TOP: #c4c4b4 1px; BORDER-LEFT: #c4c4b4 1px; WIDTH: 100%; BORDER-BOTTOM: #c4c4b4 1px; BORDER-COLLAPSE: collapse; BACKGROUND-COLOR: white" 
									borderColor="#c4c4b4" cellSpacing="0" cellPadding="3" 
									rules="all" border="1" width="100%">
								<tr class="SectionTableHeader" style="COLOR: black; BACKGROUND-COLOR: #EDE9E0">
									<xsl:for-each select="./Item[1]/node()">
										<td>
											<strong><xsl:value-of select="./@Description" /></strong>
										</td>
									</xsl:for-each>
								</tr>
								<xsl:for-each select="./Item">
									<xsl:sort select="Field[@Name=//Report/IBNReportTemplate/Sorting/Sort[1][@Asc='1']/@FieldName]/Values/Value" order="ascending"></xsl:sort>
									<xsl:sort select="Field[@Name=//Report/IBNReportTemplate/Sorting/Sort[1][@Asc='0']/@FieldName]/Values/Value" order="descending"></xsl:sort>
									<xsl:sort select="Field[@Name=//Report/IBNReportTemplate/Sorting/Sort[2][@Asc='1']/@FieldName]/Values/Value" order="ascending"></xsl:sort>
									<xsl:sort select="Field[@Name=//Report/IBNReportTemplate/Sorting/Sort[2][@Asc='0']/@FieldName]/Values/Value" order="descending"></xsl:sort>
									<xsl:sort select="Field[@Name=//Report/IBNReportTemplate/Sorting/Sort[3][@Asc='1']/@FieldName]/Values/Value" order="ascending"></xsl:sort>
									<xsl:sort select="Field[@Name=//Report/IBNReportTemplate/Sorting/Sort[3][@Asc='0']/@FieldName]/Values/Value" order="descending"></xsl:sort>
									<xsl:sort select="Field[@Name=//Report/IBNReportTemplate/Sorting/Sort[4][@Asc='1']/@FieldName]/Values/Value" order="ascending"></xsl:sort>
									<xsl:sort select="Field[@Name=//Report/IBNReportTemplate/Sorting/Sort[4][@Asc='0']/@FieldName]/Values/Value" order="descending"></xsl:sort>
									<xsl:sort select="Field[@Name=//Report/IBNReportTemplate/Sorting/Sort[5][@Asc='1']/@FieldName]/Values/Value" order="ascending"></xsl:sort>
									<xsl:sort select="Field[@Name=//Report/IBNReportTemplate/Sorting/Sort[5][@Asc='0']/@FieldName]/Values/Value" order="descending"></xsl:sort>

									<tr>
									<xsl:choose>
										<xsl:when test="position() mod 2">
											<xsl:attribute name="class">SectionTableRow</xsl:attribute>
										</xsl:when>
										<xsl:otherwise>
											<xsl:attribute name="class">SectionTableRowAlt</xsl:attribute>
										</xsl:otherwise>
									</xsl:choose>
										<xsl:for-each select="node()">
											<td valign="top">
												<xsl:choose>
													<xsl:when test="./@Type[.='3']">
														<xsl:choose>
															<xsl:when test="./@DataType[.='DateTime']">
																<table width="100%" cellSpacing="0" cellPadding="2">
																	<xsl:for-each select="Values/Value">
																		<tr>
																			<td>
																				<xsl:value-of select="vb:GetCDate(.)" />
																			</td>
																		</tr>
																	</xsl:for-each>
																</table>
															</xsl:when>
															<xsl:otherwise>
																<table width="100%" cellSpacing="0" cellPadding="2">
																	<xsl:for-each select="Values/Value">
																		<tr>
																			<td>
																				<xsl:value-of select="." />
																			</td>
																		</tr>
																	</xsl:for-each>
																</table>
															</xsl:otherwise>
														</xsl:choose>
													</xsl:when>
													<xsl:otherwise>
														<xsl:choose>
															<xsl:when test="./@DataType[.='DateTime']">
																<xsl:value-of select="vb:GetCDate(Values/Value)" />
															</xsl:when>
															<xsl:otherwise>
																<xsl:value-of select="Values/Value" />
															</xsl:otherwise>
														</xsl:choose>
													</xsl:otherwise>
												</xsl:choose>
											</td>
										</xsl:for-each>	
									</tr>	
								</xsl:for-each>
							</table>
						</xsl:if>
					</xsl:for-each>
					<table><tr><td height="19px"></td></tr></table>
				</xsl:if>
			</xsl:for-each>
   </xsl:template>

</xsl:stylesheet>

  